<?php
class NewsAdmin
{
  private $dbo = null;
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function checkNewsEditRights($newsId)
  {
    //Sprawdzenie uprawnie uytkownika
  }
  
  function showList($limit, $where)
  {
    if(!$this->dbo){
      echo 'Lista newsw nie jest dostpna.';
      return;
    }
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = (int) $_GET['page'];
    }
    else{
      $page = 0;
    }
    
    $userId = $_SESSION['zalogowany_adm']->id;
    
    //Okrelenie cakowitej liczby wierszy w tabeli News
    $query = "SELECT COUNT(*) FROM News WHERE UserId=$userId $where";
    $rowsCount = (int) $this->dbo->getQuerySingleResult($query);
    
    //Obliczenie cakowitej liczby stron z wynikami
    if($limit != 0){
      $pages = ceil($rowsCount / $limit);
    
      if($page < 0 || $page >= $pages) $page = 0;
    
      $offset = $page * $limit;
    }
    else{
      $page = 0;
      $pages = 1;
      $offset = 0;
      $limit = $rowsCount;
    }
    
    //Zapytanie pobierajce wyniki dla biecej strony
    $query = "SELECT Id, Naglowek, Data "
           . "FROM News "
           . "WHERE UserId = $userId $where"
           . "LIMIT $offset, $limit";

    if(!$news = $this->dbo->query($query)){
      return;
    }
    
    include 'templates/newsList.php';
  }
  
  function showEditForm($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Edycja istniejcej wiadomoci
    if($action == 'edit'){
      //Sprawdzenie czy istnieje parametr id
      if(!isset($_GET['id'])){
        echo 'Brak parametru id.';
        return FORM_DATA_MISSING;
      }
      
      //Sprawdzenie poprawnoci parametru id
      if(($id = (int)$_GET['id']) < 1){
        echo 'Nieprawidowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Sprawdzenie uprawnie
      if(!$this->checkNewsEditRights($id)){
        echo 'Brak uprawnie.';
        return NOT_ENOUGH_RIGHTS;
      }
      
      //Zapytanie pobierajce dane
      $query = "SELECT * FROM News WHERE Id=$id";
      
      if(!$result = $this->dbo->query($query)){
        echo 'Bd serwera. Niewaciwe zapytanie MySQL.';
        return SERVER_ERROR;
      }
      if(!$row = $result->fetch_row()){
        echo 'Nieprawidowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Ustawienie wartoci zmiennych uywanych w formularzu
      $id = $row[0];
      $naglowek = $row[2];
      $tresc = $row[3];
      
      $wtd = 'modifyNews';
      $readonly = 'readonly="readonly"';
    }
    //Dodawanie nowej wiadomoci
    else{
      $id = '';
      $naglowek = '';
      $tresc = '';
      $wtd = 'addNews';
      $readonly = '';
    }
    include 'templates/editNewsForm.php';
  }
  
  function editNews($action)
  {
    //Modyfikacja istniejcego wpisu lub dodanie nowego
  }
  
  function showSearchForm()
  {
    //Wywietlenie formularza wyszukiwania danych
  }
  
  function searchNews()
  {
    //Wyszukanie wpisu o zadanych parametrach
  }
  
  function deleteNews()
  {
    //Usunicie wybranego wpisu
  }
}
?>